<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ===== CONFIGURAÇÃO PADRÃO =====
$pfxPath = __DIR__ . '/../photopaper.pfx';
$pfxPassword = 'photo008A';

// ===== FUNÇÃO PRINCIPAL =====
function consultar_gnre_lote_raw($ambiente, $recibo, $pfxPath, $pfxPassword) {
    $url = ($ambiente == 1)
        ? "https://www.gnre.pe.gov.br/gnreWS/services/GnreResultadoLote"
        : "https://www.testegnre.pe.gov.br/gnreWS/services/GnreResultadoLote";

    $xml_consulta = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<TConsLote_GNRE xmlns="http://www.gnre.pe.gov.br" versao="2.00">
    <ambiente>{$ambiente}</ambiente>
    <numeroRecibo>{$recibo}</numeroRecibo>
</TConsLote_GNRE>
XML;

    $soap = <<<SOAP
<?xml version="1.0" encoding="UTF-8"?>
<soapenv:Envelope xmlns:soapenv="http://www.w3.org/2003/05/soap-envelope" xmlns:gnre="http://www.gnre.pe.gov.br">
   <soapenv:Header/>
   <soapenv:Body>
      <gnre:consultar>
         <gnre:gnreDadosMsg><![CDATA[$xml_consulta]]></gnre:gnreDadosMsg>
      </gnre:consultar>
   </soapenv:Body>
</soapenv:Envelope>
SOAP;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $soap);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/soap+xml; charset=utf-8; action=\"http://www.gnre.pe.gov.br/consultar\"",
        "Content-Length: " . strlen($soap),
        "User-Agent: PHP-GNRE-Client/1.0",
        "Host: www.gnre.pe.gov.br"
    ]);

    // ========= CLIENTE SSL (CERTIFICADO PFX) =========
    curl_setopt($ch, CURLOPT_SSLCERT, $pfxPath);
    curl_setopt($ch, CURLOPT_SSLCERTTYPE, 'P12');
    curl_setopt($ch, CURLOPT_SSLCERTPASSWD, $pfxPassword);

    // ========= SEGURANÇA =========
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    $curlErr = curl_error($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
    curl_close($ch);

    return [
        'response' => $response,
        'curl_error' => $curlErr,
        'http_code' => $httpCode,
        'content_type' => $contentType,
        'request' => $soap
    ];
}

// ===== INTERFACE VIA GET =====
$ambiente = isset($_GET['ambiente']) ? intval($_GET['ambiente']) : 1;
$recibo = isset($_GET['recibo']) ? trim($_GET['recibo']) : '';

if ($recibo !== '') {
    $ret = consultar_gnre_lote_raw($ambiente, $recibo, $pfxPath, $pfxPassword);

    header('Content-Type: text/html; charset=utf-8');
    echo "<h3>HTTP status: {$ret['http_code']}</h3>";
    if ($ret['curl_error']) echo "<p style='color:red'><b>Erro cURL:</b> {$ret['curl_error']}</p>";

    echo "<h4>Request SOAP enviado:</h4><pre>" . htmlspecialchars($ret['request']) . "</pre>";

    echo "<h4>Corpo bruto da resposta:</h4><pre style='white-space:pre-wrap;'>" . htmlspecialchars($ret['response']) . "</pre>";

    if ($ret['response'] && stripos($ret['response'], '<?xml') !== false) {
        $dom = new DOMDocument();
        $dom->preserveWhiteSpace = false;
        $dom->formatOutput = true;
        if (@$dom->loadXML($ret['response'])) {
            echo "<h4>XML formatado:</h4><pre>" . htmlspecialchars($dom->saveXML()) . "</pre>";
        }
    }

    exit;
}
?>

<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Consulta GNRE</title>
<style>
body { font-family: Arial; margin: 30px; }
textarea { width: 100%; height: 300px; }
</style>
</head>
<body>
<h2>Consulta Resultado GNRE</h2>
<form method="get">
  <label>Recibo:</label><br>
  <input type="text" name="recibo" required style="width:300px"><br><br>

  <label>Ambiente:</label><br>
  <input type="radio" name="ambiente" value="1" checked> Produção
  <input type="radio" name="ambiente" value="2"> Homologação
  <br><br>

  <button type="submit">Consultar</button>
</form>
</body>
</html>
